% IQ46B - Ejemplo de resolucin de un sistema de EDO.

% Borrar variables que puedan afectar:
clear all; clc;
% las 3 Constantes cinticas del mecanismo de reaccin:
k = [0.005 0.005 0.1];

% Valores iniciales de las especies en reaccin
S0  = 100;
E0  = 10;
ES0 = 0;
P0  = 0;

t0=0;               %Integra desde cero
tf=250;             %hasta tf
n=100; paso=tf/n;   %en n pasos de largo "paso"
tspan = [t0:paso:tf];

[t,y1] = ode45(@(t,y) ode_system(t,y,k), tspan, [S0 E0 ES0 P0]);

[t,y2] = ode45(@(t,y) Estacionario(t,y,k,E0), tspan, [S0 P0]);

figure(1);
plot(t/tf,y1(:,1),t/tf,y1(:,2),t/tf,y1(:,3),t/tf,y1(:,4));
legend('S','E','ES','P');
xlabel('tiempo');
ylabel('concentracin [mol/lt]');
title('Cinetica de Michaelis - Menten');

figure(2);
plot(t/tf,y1(:,1),'b',t/tf,y1(:,4),'b',t/tf,y2(:,1),'r',t/tf,y2(:,2),'r');
legend('S','P','Scs','Pcs');
xlabel('tiempo');
ylabel('concentracin [mol/lt]');
title('Comparacin Michaelis - Menten con cuasi estacionario');

figure(3);
plot(t/tf,100*(y2(:,1)-y1(:,1))./y1(:,1) ,t/tf,100*(y2(:,2)-y1(:,4))./y1(:,4));
legend('Sustrato','Producto');
xlabel('tiempo');
ylabel('porcentaje [%]');
title('error porcentual');